using System;

namespace gov.va.med.vbecs.DAL.HL7.OpenLibrary
{
	/// <summary>
	/// VBECS HL7 base exception. All HL7 exceptions must be derived from it.
	/// </summary>
    [Serializable] //Added for defect# 286500 on 3/21/2016 by Russell Stephenson
	public class HL7Exception : ApplicationException
	{
		/// <summary>
		/// CR 3006
		/// </summary>
		private object _id;

		/// <summary>
		/// CR 3006
		/// </summary>
		public object Id
		{
			get
			{
				return this._id;
			}
			set
			{
				this._id = value;
			}
		}

		/// <summary>
		/// Default constructor parameterless constructor. Should be avoided whenever possible.
		/// </summary>
		protected HL7Exception() 
			: base() {}

		/// <summary>
		/// This constructor allows specifying an error message upon throwing an exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		public HL7Exception( string message ) 
			: base( message ) {}

		/// <summary>
		/// This constructor allows adding inner exception that caused this exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		/// <param name="innerException">Inner exception that caused this exception.</param>
		public HL7Exception( string message, Exception innerException )
			: base( message, innerException ){}

		/// <summary>
		/// CR 3006
		/// This constructor allows specifying an error message upon throwing an exception;
		/// and an object to be used to Id the exception contents, or whatever you want.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		/// <param name="id">object to be used to Id the exception contents, etc.</param>
		public HL7Exception( string message, object id ) 
			: base( message ) 
		{
			this._id = id;
		}
	}
}
